<?php

namespace App\Http\Controllers;

use App\Mail\ContactMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function contactMail(Request $request){

        $details = [
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'message' => $request->message,
        ];

        Mail::to('info@usaitmarketing.com')->send(new ContactMail($details));
        return redirect()->back()->with('message_sent', 'Your Mail Has Been Sent');

    }
}
