<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('frontend/assets/images/logo.png')); ?>">
    <title>USA IT Marketing</title>

    <!-- Bootstrap core CSS -->
    <link href="<?php echo e(asset('frontend/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Additional CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/fontawesome.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/animated.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/assets/css/owl.css')); ?>">

</head>

<body>

    <!-- ***** Preloader Start ***** -->
    <div id="js-preloader" class="js-preloader">
        <div class="preloader-inner">
            <span class="dot"></span>
            <div class="dots">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </div>
    <!-- ***** Preloader End ***** -->

    <!-- ***** Header Area Start ***** -->
    <header class="header-area header-sticky wow slideInDown" data-wow-duration="0.75s" data-wow-delay="0s">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <nav class="main-nav">
                        <!-- ***** Logo Start ***** -->
                        <a href="index.html" class="logo">
                            <img src="<?php echo e(asset('frontend/assets/images/logo.png')); ?>" alt="">
                        </a>
                        <!-- ***** Logo End ***** -->
                        <!-- ***** Menu Start ***** -->
                        <ul class="nav">
                            <li class="scroll-to-section"><a href="index.html" class="active">Home</a></li>
                            <li class="scroll-to-section"><a href="#about">About Us</a></li>
                            <li class="scroll-to-section"><a href="#services">Services</a></li>
                            <li class="scroll-to-section"><a href="#portfolio">Portfolio</a></li>
                            <!-- <li class="scroll-to-section"><a href="#blog">Blog</a></li> -->
                            <li class="scroll-to-section"><a href="#contact">Message Us</a></li>
                            <li class="scroll-to-section">
                                <div class="main-red-button"><a href="#contact">Contact Now</a></div>
                            </li>
                        </ul>
                        <a class='menu-trigger'>
                            <span>Menu</span>
                        </a>
                        <!-- ***** Menu End ***** -->
                    </nav>
                </div>
            </div>
        </div>
    </header>
    <!-- ***** Header Area End ***** -->

    <div class="main-banner wow fadeIn" id="about" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-6 align-self-center">
                            <div class="left-content header-text wow fadeInLeft" data-wow-duration="1s" data-wow-delay="1s">
                                <h6>Welcome to USA <span>IT </span>Marketing</h6>
                                <h2>We Promise To Provide <em>Best </em> <span>Digital</span> Services</h2>
                                <p>We are a creative marketing agency who create practical, relevant and effective solution for your business. Digital agency in Bangladesh that provides arrays of services in order to craft meaningful communications. We believe
                                    in formulating strategies and meaningful contents for the digital media that leads to superb result for our valued patrons.
                                </p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="right-image wow fadeInRight" data-wow-duration="1s" data-wow-delay="0.5s">
                                <img src="<?php echo e(asset('frontend/assets/images/banner-right-image.png')); ?>" alt="team meeting">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="services" class="about-us section">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="left-image wow fadeIn" data-wow-duration="1s" data-wow-delay="0.2s">
                        <img src="<?php echo e(asset('frontend/assets/images/about-left-image.png')); ?>" alt="person graphic">
                    </div>
                </div>
                <div class="col-lg-8 align-self-center">
                    <div class="services">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="item wow fadeIn" data-wow-duration="1s" data-wow-delay="0.5s">
                                    <div class="icon">
                                        <img src="<?php echo e(asset('frontend/assets/images/service-icon-01.png')); ?>" alt="reporting">
                                    </div>
                                    <div class="right-text">
                                        <h4>Social Media Marketing</h4>
                                        <p>Social media marketing uses social media networks for marketing and branding.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="item wow fadeIn" data-wow-duration="1s" data-wow-delay="0.7s">
                                    <div class="icon">
                                        <img src="<?php echo e(asset('frontend/assets/images/service-icon-02.png')); ?>" alt="">
                                    </div>
                                    <div class="right-text">
                                        <h4>Search Engine Optimization (SEO)</h4>
                                        <p>Process of improving your site to increase its visibility on search engines like Google.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="item wow fadeIn" data-wow-duration="1s" data-wow-delay="0.9s">
                                    <div class="icon">
                                        <img src="<?php echo e(asset('frontend/assets/images/service-icon-03.png')); ?>" alt="">
                                    </div>
                                    <div class="right-text">
                                        <h4>Web Development</h4>
                                        <p>Web development refers to the building, creating, and maintaining of websites.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="item wow fadeIn" data-wow-duration="1s" data-wow-delay="1.1s">
                                    <div class="icon">
                                        <img src="<?php echo e(asset('frontend/assets/images/service-icon-04.png')); ?>" alt="">
                                    </div>
                                    <div class="right-text">
                                        <h4>Graphic Design</h4>
                                        <p>Graphic design is where professionals create visual content.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="services" class="our-services section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 align-self-center  wow fadeInLeft" data-wow-duration="1s" data-wow-delay="0.2s">
                    <div class="left-image">
                        <img src="<?php echo e(asset('frontend/assets/images/services-left-image.png')); ?>" alt="">
                    </div>
                </div>
                <div class="col-lg-6 wow fadeInRight" data-wow-duration="1s" data-wow-delay="0.2s">
                    <div class="section-heading">
                        <h2>Grow your business with our <em>Expert</em> Advice &amp; <span>Excellent</span> Services</h2>
                        <br>
                        <h4>Mission</h4>
                        <p>In the era of digitization, marketplace has become the place of socialization. We are commited to assist the clients to achieve their most ambitious marketing goal and strategic communication objectives through tactical counseling,
                            creative solutions and time -responsive service. </p>
                        <h4>Vision</h4>
                        <p>We want to be final resort marketing solution for any determined businesses.</p>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="first-bar progress-skill-bar">
                                <h4>Social Media Marketing</h4>
                                <span>80%</span>
                                <div class="filled-bar"></div>
                                <div class="full-bar"></div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="second-bar progress-skill-bar">
                                <h4>Search Engine Optimization (SEO)</h4>
                                <span>85%</span>
                                <div class="filled-bar"></div>
                                <div class="full-bar"></div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="third-bar progress-skill-bar">
                                <h4>Web Development</h4>
                                <span>95%</span>
                                <div class="filled-bar"></div>
                                <div class="full-bar"></div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="second-bar progress-skill-bar">
                                <h4>Graphic Design</h4>
                                <span>85%</span>
                                <div class="filled-bar"></div>
                                <div class="full-bar"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="portfolio" class="our-portfolio section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 offset-lg-3">
                    <div class="section-heading  wow bounceIn" data-wow-duration="1s" data-wow-delay="0.2s">
                        <h2>What <em>Sets</em> Us <span>Apart</span></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <a href="#">
                        <div class="item wow bounceInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                            <div class="hidden-content">
                                <h4>Honesty</h4>
                                <p>We believe Honesty is the most important thing behind success. This is our first pillar.</p>
                            </div>
                            <div class="showed-content">
                                <img src="<?php echo e(asset('frontend/assets/images/portfolio-image.png')); ?>" alt="">
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <a href="#">
                        <div class="item wow bounceInUp" data-wow-duration="1s" data-wow-delay="0.4s">
                            <div class="hidden-content">
                                <h4>Attention to Detail</h4>
                                <p>Working with our clients, we listen and understand their overall needs and vision.</p>
                            </div>
                            <div class="showed-content">
                                <img src="<?php echo e(asset('frontend/assets/images/portfolio-image.png')); ?>" alt="">
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <a href="#">
                        <div class="item wow bounceInUp" data-wow-duration="1s" data-wow-delay="0.5s">
                            <div class="hidden-content">
                                <h4>Competitive Pricing</h4>
                                <p>Keeping our services affordable for our clients is our top priority.</p>
                            </div>
                            <div class="showed-content">
                                <img src="<?php echo e(asset('frontend/assets/images/portfolio-image.png')); ?>" alt="">
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <a href="#">
                        <div class="item wow bounceInUp" data-wow-duration="1s" data-wow-delay="0.6s">
                            <div class="hidden-content">
                                <h4>Professionals</h4>
                                <p>We are a group of market leading professionals.</p>
                            </div>
                            <div class="showed-content">
                                <img src="<?php echo e(asset('frontend/assets/images/portfolio-image.png')); ?>" alt="">
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- <div id="blog" class="our-blog section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.25s">
                    <div class="section-heading">
                        <h2>Check Out What Is <em>Trending</em> In Our Latest <span>News</span></h2>
                    </div>
                </div>
                <div class="col-lg-6 wow fadeInDown" data-wow-duration="1s" data-wow-delay="0.25s">
                    <div class="top-dec">
                        <img src="assets/images/blog-dec.png" alt="">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.25s">
                    <div class="left-image">
                        <a href="#"><img src="assets/images/big-blog-thumb.jpg" alt="Workspace Desktop"></a>
                        <div class="info">
                            <div class="inner-content">
                                <ul>
                                    <li><i class="fa fa-calendar"></i> 24 Mar 2022</li>
                                    <li><i class="fa fa-users"></i> USAITMarketing</li>
                                    <li><i class="fa fa-folder"></i> Branding</li>
                                </ul>
                                <a href="#">
                                    <h4>SEO Agency &amp; Digital Marketing</h4>
                                </a>
                                <p>Lorem ipsum dolor sit amet, consectetur and sed doer ket eismod tempor incididunt ut labore et dolore magna...</p>
                                <div class="main-blue-button">
                                    <a href="#">Discover More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.25s">
                    <div class="right-list">
                        <ul>
                            <li>
                                <div class="left-content align-self-center">
                                    <span><i class="fa fa-calendar"></i> 18 Mar 2021</span>
                                    <a href="#">
                                        <h4>New Websites &amp; Backlinks</h4>
                                    </a>
                                    <p>Lorem ipsum dolor sit amsecteturii and sed doer ket eismod...</p>
                                </div>
                                <div class="right-image">
                                    <a href="#"><img src="assets/images/blog-thumb-01.jpg" alt=""></a>
                                </div>
                            </li>
                            <li>
                                <div class="left-content align-self-center">
                                    <span><i class="fa fa-calendar"></i> 14 Mar 2021</span>
                                    <a href="#">
                                        <h4>SEO Analysis &amp; Content Ideas</h4>
                                    </a>
                                    <p>Lorem ipsum dolor sit amsecteturii and sed doer ket eismod...</p>
                                </div>
                                <div class="right-image">
                                    <a href="#"><img src="assets/images/blog-thumb-01.jpg" alt=""></a>
                                </div>
                            </li>
                            <li>
                                <div class="left-content align-self-center">
                                    <span><i class="fa fa-calendar"></i> 06 Mar 2021</span>
                                    <a href="#">
                                        <h4>SEO Tips &amp; Digital Marketing</h4>
                                    </a>
                                    <p>Lorem ipsum dolor sit amsecteturii and sed doer ket eismod...</p>
                                </div>
                                <div class="right-image">
                                    <a href="#"><img src="assets/images/blog-thumb-01.jpg" alt=""></a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div> -->

    <div id="contact" class="contact-us section">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 align-self-center wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.25s">
                    <div class="section-heading">
                        <h2>Feel Free To Send Us a Message About Your Needs</h2>
                        <p>Find Us: The Laureate, Level #C6, House #56, Road #11, Block #F, Dhaka-1213</p>
                        <div class="phone-info">
                            <h4>Call Us: <span><i class="fa fa-phone"></i> <a href="tel:(+880) 1729272673">(+880) 1729272673</a></span></h4>
                        </div>
                        <div class="phone-info">
                            <h4>Email Us: <span><i class="fa fa-envelope"></i> <a href="mailto:info@usaitmarketing.com">info@usaitmarketing.com</a></span></h4>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 wow fadeInRight" data-wow-duration="0.5s" data-wow-delay="0.25s">
                    <form id="contact" action="<?php echo e(route('contact.send')); ?>" method="post">
                        <?php if(Session::has('message_sent')): ?>
                                <div class="alert alert-success" role="alert"><?php echo e(Session::get('message_sent')); ?></div>
                            <?php endif; ?>
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-lg-6">
                                <fieldset>
                                    <input type="name" name="name" id="name" placeholder="Name" autocomplete="on" required>
                                </fieldset>
                            </div>
                            <div class="col-lg-6">
                                <fieldset>
                                    <input type="tel" name="phone" id="phone" placeholder="Phone" autocomplete="on" required>
                                </fieldset>
                            </div>
                            <div class="col-lg-12">
                                <fieldset>
                                    <input type="text" name="email" id="email" pattern="[^ @]*@[^ @]*" placeholder="Your Email" required="">
                                </fieldset>
                            </div>
                            <div class="col-lg-12">
                                <fieldset>
                                    <textarea name="message" type="text" class="form-control" id="message" placeholder="Message" required=""></textarea>
                                </fieldset>
                            </div>
                            <div class="col-lg-12">
                                <fieldset>
                                    <button type="submit" id="form-submit" class="main-button ">Send Message</button>
                                </fieldset>
                            </div>
                        </div>
                        <div class="contact-dec">
                            <img src="<?php echo e(asset('frontend/assets/images/contact-decoration.png')); ?>" alt="">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <footer>
        <div class="container">
            <div class="row">
                <div class="col-lg-12 wow fadeIn" data-wow-duration="1s" data-wow-delay="0.25s">
                    <p>© Copyright 2022 USA IT Marketing. All Rights Reserved.

                </div>
            </div>
        </div>
    </footer>
    <!-- Scripts -->
    <script src="<?php echo e(asset('frontend/vendor/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/owl-carousel.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/animation.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/imagesloaded.js')); ?>"></script>
    <script src="<?php echo e(asset('frontend/assets/js/custom.js')); ?>"></script>

</body>

</html><?php /**PATH D:\xampp\htdocs\github\usaitmarketing\resources\views/welcome.blade.php ENDPATH**/ ?>